Ext.data.JsonP.sol_common_ix_DynKwlDatabaseIterator({"tagname":"class","name":"sol.common.ix.DynKwlDatabaseIterator","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.ix.DynKwlDatabaseIterator.js","href":"lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator"}],"author":[{"tagname":"author","name":"NM, ELO Digital Office GmbH","email":null}],"version":["1.03.000"],"eloix":true,"requires":["sol.common.Locale","sol.common.SordUtils","sol.common.StringUtils","sol.common.UserProfile","sol.common.ix.DynKwlUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":["sol.common.ix.DynKwlMixin"],"uses":[],"members":[{"name":"dbName","tagname":"cfg","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"cfg-dbName","meta":{}},{"name":"jdbc","tagname":"cfg","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"cfg-jdbc","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"sqlParams","tagname":"cfg","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"cfg-sqlParams","meta":{"required":true}},{"name":"sqlQuery","tagname":"cfg","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"cfg-sqlQuery","meta":{"required":true}},{"name":"tableHeaders","tagname":"cfg","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"cfg-tableHeaders","meta":{"required":true}},{"name":"tableKeyNames","tagname":"cfg","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"cfg-tableKeyNames","meta":{"required":true}},{"name":"tableTitle","tagname":"cfg","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"cfg-tableTitle","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"errorMessage","tagname":"property","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"property-errorMessage","meta":{}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"mixin","tagname":"property","owner":"sol.common.ix.DynKwlMixin","id":"property-mixin","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"close","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-close","meta":{}},{"name":"createDbParameterList","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-createDbParameterList","meta":{}},{"name":"formatDecimals","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-formatDecimals","meta":{"deprecated":{"text":"<p>Use <a href=\"#!/api/sol.common.ix.DynKwlMixin-method-formatRow\" rel=\"sol.common.ix.DynKwlMixin-method-formatRow\" class=\"docClass\">sol.common.ix.DynKwlMixin.formatRow</a> instead\nFormats decimal numbers</p>\n"}}},{"name":"formatNumber","tagname":"method","owner":"sol.common.ix.DynKwlMixin","id":"method-formatNumber","meta":{"private":true}},{"name":"formatRow","tagname":"method","owner":"sol.common.ix.DynKwlMixin","id":"method-formatRow","meta":{"protected":true}},{"name":"getHeader","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-getHeader","meta":{}},{"name":"getIndexFromName","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-getIndexFromName","meta":{"private":true}},{"name":"getKeyNames","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-getKeyNames","meta":{}},{"name":"getMessage","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-getMessage","meta":{}},{"name":"getNextRow","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-getNextRow","meta":{}},{"name":"getTableKeyNames","tagname":"method","owner":"sol.common.ix.DynKwlMixin","id":"method-getTableKeyNames","meta":{"protected":true}},{"name":"getTitle","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-getTitle","meta":{}},{"name":"hasMoreRows","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-hasMoreRows","meta":{}},{"name":"initOpen","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-initOpen","meta":{}},{"name":"initOpenMap","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-initOpenMap","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-initialize","meta":{"private":true}},{"name":"open","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-open","meta":{}},{"name":"openDbConnection","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-openDbConnection","meta":{}},{"name":"openMap","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-openMap","meta":{}},{"name":"prepareRow","tagname":"method","owner":"sol.common.ix.DynKwlDatabaseIterator","id":"method-prepareRow","meta":{}}],"code_type":"ext_define","id":"class-sol.common.ix.DynKwlDatabaseIterator","short_doc":"Database Iterator used by dynamic keyword lists. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ix.DynKwlDatabaseIterator</strong></div></div><h4>Mixins</h4><div class='dependency'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='docClass'>sol.common.ix.DynKwlMixin</a></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Locale' rel='sol.common.Locale' class='docClass'>sol.common.Locale</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><div class='dependency'><a href='#!/api/sol.common.UserProfile' rel='sol.common.UserProfile' class='docClass'>sol.common.UserProfile</a></div><div class='dependency'><a href='#!/api/sol.common.ix.DynKwlUtils' rel='sol.common.ix.DynKwlUtils' class='docClass'>sol.common.ix.DynKwlUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator' target='_blank'>lib_sol.common.ix.DynKwlDatabaseIterator.js</a></div></pre><div class='doc-contents'><p>Database Iterator used by dynamic keyword lists.\nThis class provides an abstract layer that simplifies the usage of database connections.</p>\n\n<p>Dynamic keyword lists simplify the use of gathering data from external services.\nThis implementation helps in querying database tables. Each query is returned as a table\nwhich contains a title and a specific table configuration.</p>\n\n<p>Queries are defined by sql statements that can contain placeholders ?.\nEach placeholder must be defined in the sqlParams array. If no name is given, the given filter value will be used.\nIn case the field is empty, a message can be set, which is displayed by the client.\nThanks to a mode type filters can be applied in different ways.</p>\n\n<pre><code>{mode: 'STARTS_WITH'},\n{name: 'COMPANY_CODE', message: 'please select a company.'},\n</code></pre>\n\n<p>Following modes are supported. Please mind that the modes ENDS_WITH and CONTAINS might lead to expansive queries.</p>\n\n<ul>\n<li><b>STARTS_WITH</b>: String starts with the given value. e.g. COMPA%.</li>\n<li><b>ENDS_WITH</b>: String ends with the given value. e.g. %COMPA.</li>\n<li><b>CONTAINS</b>: String contains the given value. e.g. %COMPA%.</li>\n<li><b>No type name given</b>: String equals the given value. e.g. \"COMPA\".</li>\n</ul>\n\n\n<h1>Localization</h1>\n\n<p>SQL Queries can be localized by passing the locale key as a parameter. Therefore the valueType 'LANGUAGE' can be used.</p>\n\n<pre><code>sqlQuery: \"select code, description from sol_invoice_trade_charge where language = ? order by description\",\nsqlParams: [{ valueType: 'LANGUAGE' }],\n</code></pre>\n\n<h1>Examples</h1>\n\n<p>Example implementation as instance</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>('<a href=\"#!/api/sol.common.ix.DynKwlDatabaseIterator\" rel=\"sol.common.ix.DynKwlDatabaseIterator\" class=\"docClass\">sol.common.ix.DynKwlDatabaseIterator</a>', {\n  tableTitle: 'Company',\n  sqlQuery: \"select CODE, NAME, STREET, ZIPCODE, CITY, COUNTRY_CODE from sol_invoice_company where CODE like ? OR NAME like ?\",\n  sqlParams: [\n    {mode: 'STARTS_WITH'},\n    {mode: 'CONTAINS'}\n  ],\n  tableKeyNames: [\"COMPANY_CODE\", \"COMPANY_NAME\", null, null, null, null],\n  tableHeaders: [\"No.\", \"Name\", \"Street\", \"Zip\", \"City\", \"Country\"]\n});\n</code></pre>\n\n<p>Example implementation as a custom class.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>('sol.invoice.ix.dynkwl.Company', {\n  extend: '<a href=\"#!/api/sol.common.ix.DynKwlDatabaseIterator\" rel=\"sol.common.ix.DynKwlDatabaseIterator\" class=\"docClass\">sol.common.ix.DynKwlDatabaseIterator</a>',\n  tableTitle: 'Company',\n  sqlQuery: \"select CODE, NAME, STREET, ZIPCODE, CITY, COUNTRY_CODE from sol_invoice_company where CODE like ? OR NAME like ?\",\n  sqlParams: [\n    {mode: 'STARTS_WITH'},\n    {mode: 'CONTAINS'}\n  ],\n  tableKeyNames: [\"COMPANY_CODE\", \"COMPANY_NAME\", null, null, null, null],\n  tableHeaders: [\"No.\", \"Name\", \"Street\", \"Zip\", \"City\", \"Country\"]\n});\n</code></pre>\n\n<p>Example usage in ix dynkwl-script:</p>\n\n<pre><code>function getDataIterator() {\n  var iterator;\n  try {\n    iterator = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>('sol.invoice.ix.dynkwl.Company', {\n      dbName: 'customers',\n      jdbc: 'testconn'\n    });\n    return new DynamicKeywordDataProvider(iterator);\n  } finally {\n    log.info(\")getDataIterator\");\n  }\n}\n</code></pre>\n      <p class='version-tag'>Version: <b>1.03.000</b></p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-sqlParams' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-cfg-sqlParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-cfg-sqlParams' class='name expandable'>sqlParams</a> : Array<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>fields that are used by the prepared statements. ...</div><div class='long'><p>fields that are used by the prepared statements. (Array of config options).</p>\n\n<pre><code>[{ name: 'IX_MAP_NUMBER', mode: 'STARTS', message: 'field x missing' }]\n</code></pre>\n\n<p>if no name is provided current focused field is used.</p>\n</div></div></div><div id='cfg-sqlQuery' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-cfg-sqlQuery' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-cfg-sqlQuery' class='name expandable'>sqlQuery</a> : string<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>sql-query that can contain placeholders ? used by prepared statements. ...</div><div class='long'><p>sql-query that can contain placeholders ? used by prepared statements.</p>\n\n<pre><code>\"select CODE, NAME, STREET, ZIPCODE, CITY, COUNTRY_CODE from sol_invoice_company where CODE like ? OR NAME like ?\"\n</code></pre>\n</div></div></div><div id='cfg-tableHeaders' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-cfg-tableHeaders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-cfg-tableHeaders' class='name expandable'>tableHeaders</a> : Array<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>column header names. ...</div><div class='long'><p>column header names. if null column is hidden in the client.</p>\n\n<pre><code>[\"No.\", \"Name\", \"Street\", \"Zip\", \"City\", \"Country\"]\n</code></pre>\n</div></div></div><div id='cfg-tableKeyNames' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-cfg-tableKeyNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-cfg-tableKeyNames' class='name expandable'>tableKeyNames</a> : Array<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>mapping between columns and elo group or map fields. ...</div><div class='long'><p>mapping between columns and elo group or map fields. if null, value is not transferred.</p>\n\n<pre><code>// GRP field     map static field           map table field\n['INVOICE_NO', 'IX_MAP_INVOICE_DUE_DATE', 'IX_MAP_ACCDESC{i}'];\n</code></pre>\n\n<p>Map fields must contain IX_MAP as a prefix and can optionally use {i} as a counter value.</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-dbName' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-cfg-dbName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-cfg-dbName' class='name expandable'>dbName</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'>JDBC: Database name for the jdbc connection. ...</div><div class='long'><p>JDBC: Database name for the jdbc connection. Should not be defined if table is part of the current archive database.</p>\n</div></div></div><div id='cfg-jdbc' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-cfg-jdbc' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-cfg-jdbc' class='name expandable'>jdbc</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'>JDBC: Name of the jdbc connection. ...</div><div class='long'><p>JDBC: Name of the jdbc connection. Should not be defined if table is part of the current archive database.</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-tableTitle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-cfg-tableTitle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-cfg-tableTitle' class='name expandable'>tableTitle</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'>name of this table. ...</div><div class='long'><p>name of this table. The title is displayed by the client.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-errorMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-property-errorMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-property-errorMessage' class='name expandable'>errorMessage</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Error message that is passed to the client if value is missing. ...</div><div class='long'><p>Error message that is passed to the client if value is missing.</p>\n<p>Defaults to: <code>&quot;&quot;</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-mixin' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='defined-in docClass'>sol.common.ix.DynKwlMixin</a><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-property-mixin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-property-mixin' class='name expandable'>mixin</a> : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>true</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-close' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-close' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-close' class='name expandable'>close</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Closes the connection for both map and non map capable clients. ...</div><div class='long'><p>Closes the connection for both map and non map capable clients.</p>\n</div></div></div><div id='method-createDbParameterList' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-createDbParameterList' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-createDbParameterList' class='name expandable'>createDbParameterList</a>( <span class='pre'>ec, focusField, fieldIndex, map, sord</span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Internal function that utilizes the creation of database parameter lists used by\nprepared statements. ...</div><div class='long'><p>Internal function that utilizes the creation of database parameter lists used by\nprepared statements.</p>\n\n<p>configuration as defined by sqlParams is used to identify fields and the query type.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ec</span> : Object<div class='sub-desc'><p>IX ScriptExecContext</p>\n</div></li><li><span class='pre'>focusField</span> : String<div class='sub-desc'><p>currently focused field</p>\n</div></li><li><span class='pre'>fieldIndex</span> : String<div class='sub-desc'><p>index field</p>\n</div></li><li><span class='pre'>map</span> : Object<div class='sub-desc'><p>map of all entries passed by the client</p>\n</div></li><li><span class='pre'>sord</span> : Object<div class='sub-desc'><p>working version of the current sord object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>values for prepared statement</p>\n</div></li></ul></div></div></div><div id='method-formatDecimals' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-formatDecimals' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-formatDecimals' class='name expandable'>formatDecimals</a>( <span class='pre'>row, defs, defs, defs</span> )<span class=\"signature\"><span class='deprecated' >deprecated</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n        <div class='rounded-box deprecated-box deprecated-tag-box'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        <p>Use <a href=\"#!/api/sol.common.ix.DynKwlMixin-method-formatRow\" rel=\"sol.common.ix.DynKwlMixin-method-formatRow\" class=\"docClass\">sol.common.ix.DynKwlMixin.formatRow</a> instead\nFormats decimal numbers</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>row</span> : Array<div class='sub-desc'><p>Row</p>\n</div></li><li><span class='pre'>defs</span> : Array<div class='sub-desc'><p>definitions</p>\n</div></li><li><span class='pre'>defs</span> : String<div class='sub-desc'><p>[].params.columnNames Column names</p>\n</div></li><li><span class='pre'>defs</span> : Array<div class='sub-desc'><p>[].params.columnIndexes Column indexes</p>\n</div></li></ul></div></div></div><div id='method-formatNumber' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='defined-in docClass'>sol.common.ix.DynKwlMixin</a><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-method-formatNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-method-formatNumber' class='name expandable'>formatNumber</a>( <span class='pre'>value, params</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Formats decimal numbers using sol.common.Locale.formatDecimal. ...</div><div class='long'><p>Formats decimal numbers using <a href=\"#!/api/sol.common.Locale-method-formatDecimal\" rel=\"sol.common.Locale-method-formatDecimal\" class=\"docClass\">sol.common.Locale.formatDecimal</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-formatRow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='defined-in docClass'>sol.common.ix.DynKwlMixin</a><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-method-formatRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-method-formatRow' class='name expandable'>formatRow</a>( <span class='pre'>row</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Uses this.formatting to apply formatting to a table row. ...</div><div class='long'><p>Uses <code>this.formatting</code> to apply formatting to a table row.</p>\n\n<h1>Format decimal</h1>\n\n<p>See also <a href=\"#!/api/sol.common.Locale-method-formatDecimal\" rel=\"sol.common.Locale-method-formatDecimal\" class=\"docClass\">sol.common.Locale.formatDecimal</a>.</p>\n\n<pre><code>formatting = [\n  { columnNames: [\"MY_OUTPUT_COLUMN1\"], minimumFractionDigits: 0, maximumFractionDigits: 2 },\n  { columnNames: [\"MY_OUTPUT_COLUMN2\", \"ANOTHER_OUTPUT_COLUMN\"], maximumFractionDigits: 4 }\n];\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>row</span> : String[]<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getHeader' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-getHeader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-getHeader' class='name expandable'>getHeader</a>( <span class='pre'></span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the header of this table that can be displayed by the clients. ...</div><div class='long'><p>Returns the header of this table that can be displayed by the clients.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>table header</p>\n</div></li></ul></div></div></div><div id='method-getIndexFromName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-getIndexFromName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-getIndexFromName' class='name expandable'>getIndexFromName</a>( <span class='pre'>name</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getKeyNames' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-getKeyNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-getKeyNames' class='name expandable'>getKeyNames</a>( <span class='pre'></span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the keys of this table that can be used in order to map\nmap or group fields with columns. ...</div><div class='long'><p>Returns the keys of this table that can be used in order to map\nmap or group fields with columns.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>table keys</p>\n</div></li></ul></div></div></div><div id='method-getMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-getMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-getMessage' class='name expandable'>getMessage</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the error message that should be displayed by the client\ninstead of the table data. ...</div><div class='long'><p>Returns the error message that should be displayed by the client\ninstead of the table data.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>error message</p>\n</div></li></ul></div></div></div><div id='method-getNextRow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-getNextRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-getNextRow' class='name expandable'>getNextRow</a>( <span class='pre'>ec</span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the next row of the table. ...</div><div class='long'><p>Returns the next row of the table.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ec</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>Events context</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>table row</p>\n</div></li></ul></div></div></div><div id='method-getTableKeyNames' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='defined-in docClass'>sol.common.ix.DynKwlMixin</a><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-method-getTableKeyNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-method-getTableKeyNames' class='name expandable'>getTableKeyNames</a>( <span class='pre'>focusFieldName</span> ) : String[]<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines the table keys for the output of the dynamic kwl. ...</div><div class='long'><p>Determines the table keys for the output of the dynamic kwl.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>focusFieldName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTitle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-getTitle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-getTitle' class='name expandable'>getTitle</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a title for this table used by the user interface. ...</div><div class='long'><p>Returns a title for this table used by the user interface.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>title</p>\n</div></li></ul></div></div></div><div id='method-hasMoreRows' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-hasMoreRows' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-hasMoreRows' class='name expandable'>hasMoreRows</a>( <span class='pre'></span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns true if table has more rows. ...</div><div class='long'><p>Returns true if table has more rows.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>has more rows</p>\n</div></li></ul></div></div></div><div id='method-initOpen' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-initOpen' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-initOpen' class='name expandable'>initOpen</a>( <span class='pre'>ec, sord, fieldName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Initializes the list for an open call ...</div><div class='long'><p>Initializes the list for an <code>open</code> call</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ec</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>Events context</p>\n</div></li><li><span class='pre'>sord</span> : Object<div class='sub-desc'><p>working version of the current sord object</p>\n</div></li><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>name of the currently focused field</p>\n</div></li></ul></div></div></div><div id='method-initOpenMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-initOpenMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-initOpenMap' class='name expandable'>initOpenMap</a>( <span class='pre'>ec, map, focusName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Initializes the list for an openMap call ...</div><div class='long'><p>Initializes the list for an <code>openMap</code> call</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ec</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>Events context</p>\n</div></li><li><span class='pre'>map</span> : Object<div class='sub-desc'><p>map of all entries passed by the client</p>\n</div></li><li><span class='pre'>focusName</span> : String<div class='sub-desc'><p>name of the currently focused field</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.DynKwlMixin-method-initialize\" rel=\"sol.common.ix.DynKwlMixin-method-initialize\" class=\"docClass\">sol.common.ix.DynKwlMixin.initialize</a></p></div></div></div><div id='method-open' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-open' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-open' class='name expandable'>open</a>( <span class='pre'>ec, sord, fieldName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Opens a connection for the elo java client and non map field capable clients. ...</div><div class='long'><p>Opens a connection for the elo java client and non map field capable clients.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ec</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>Events context</p>\n</div></li><li><span class='pre'>sord</span> : Object<div class='sub-desc'><p>working version of the current sord object</p>\n</div></li><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>name of the currently focused field</p>\n</div></li></ul></div></div></div><div id='method-openDbConnection' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-openDbConnection' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-openDbConnection' class='name expandable'>openDbConnection</a>( <span class='pre'></span> ) : de.elo.ix.jscript.DBConnection<span class=\"signature\"></span></div><div class='description'><div class='short'>Internal function that opens a database connection for map and non map\ncapable clients. ...</div><div class='long'><p>Internal function that opens a database connection for map and non map\ncapable clients. Via default the archive database is used but can be changed\nto a custom database connection if jdbc and dbName has been set.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.jscript.DBConnection</span><div class='sub-desc'><p>database connection</p>\n</div></li></ul></div></div></div><div id='method-openMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-openMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-openMap' class='name expandable'>openMap</a>( <span class='pre'>ec, map, focusName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Opens a connection for elo wf forms and map field capable components ...</div><div class='long'><p>Opens a connection for elo wf forms and map field capable components</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ec</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>Events context</p>\n</div></li><li><span class='pre'>map</span> : Object<div class='sub-desc'><p>map of all entries passed by the client</p>\n</div></li><li><span class='pre'>focusName</span> : String<div class='sub-desc'><p>name of the currently focused field</p>\n</div></li></ul></div></div></div><div id='method-prepareRow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlDatabaseIterator'>sol.common.ix.DynKwlDatabaseIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlDatabaseIterator.html#sol-common-ix-DynKwlDatabaseIterator-method-prepareRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator-method-prepareRow' class='name expandable'>prepareRow</a>( <span class='pre'>row</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Initializes the list ...</div><div class='long'><p>Initializes the list</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>row</span> : Array<div class='sub-desc'><p>Row</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});